﻿@extends('layouts.base')

@section('title', $settings->site_title)

@inject('content', 'App\Http\Controllers\FrontController')

@section('content')

<!-- Hero Section -->
<section class="relative min-h-screen lg:min-h-[90vh] flex items-center overflow-hidden" x-data="{ currentSlide: 0, slides: 4 }" x-init="setInterval(() => { currentSlide = (currentSlide + 1) % slides }, 5000)">
    <!-- Background Video/Images -->
    <div class="absolute inset-0 z-0">
        <!-- Video Background for first slide -->
        <div x-show="currentSlide === 0" x-cloak x-transition:enter="transition-opacity duration-1000" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="transition-opacity duration-1000" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" class="absolute inset-0">
            <video autoplay muted loop class="w-full h-full object-cover">
                <source src="temp/custom/images/slider/airplane_takeoff.mp4" type="video/mp4">
            </video>
        </div>
        
        <!-- Image backgrounds for other slides -->
        <div x-show="currentSlide === 1" x-cloak x-transition:enter="transition-opacity duration-1000" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="transition-opacity duration-1000" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" class="absolute inset-0 bg-cover bg-center" style="background-image: url('temp/custom/images/slider/trucks.jpg');"></div>
        
        <div x-show="currentSlide === 2" x-cloak x-transition:enter="transition-opacity duration-1000" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="transition-opacity duration-1000" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" class="absolute inset-0 bg-cover bg-center" style="background-image: url('temp/custom/images/slider/home-main.jpg');"></div>
        
        <div x-show="currentSlide === 3" x-cloak x-transition:enter="transition-opacity duration-1000" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="transition-opacity duration-1000" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" class="absolute inset-0 bg-cover bg-center" style="background-image: url('temp/custom/images/slider/slide3.jpg');"></div>
        
        <!-- Dark overlay -->
        <div class="absolute inset-0 bg-black bg-opacity-50"></div>
    </div>

    <!-- Hero Content -->
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-12 gap-10 items-center">
            <div class="lg:col-span-7 text-center lg:text-left">
                <div class="inline-flex items-center px-4 py-2 rounded-full border border-white/20 bg-white/10 text-sm text-white/90 mb-6">
                    Global logistics for modern commerce
                </div>
                <h1 class="text-4xl md:text-6xl lg:text-7xl font-bold mb-6 leading-tight text-white">
                    <span x-show="currentSlide === 0" x-cloak x-transition:enter="transition-all duration-1000 delay-300" x-transition:enter-start="opacity-0 translate-y-8" x-transition:enter-end="opacity-100 translate-y-0">
                        Global Logistics<br><span class="text-primary-400">Precisely Delivered</span>
                    </span>
                    <span x-show="currentSlide === 1" x-cloak x-transition:enter="transition-all duration-1000 delay-300" x-transition:enter-start="opacity-0 translate-y-8" x-transition:enter-end="opacity-100 translate-y-0">
                        Express Courier<br><span class="text-primary-400">Built for Certainty</span>
                    </span>
                    <span x-show="currentSlide === 2" x-cloak x-transition:enter="transition-all duration-1000 delay-300" x-transition:enter-start="opacity-0 translate-y-8" x-transition:enter-end="opacity-100 translate-y-0">
                        Freight Solutions<br><span class="text-primary-400">Engineered for Scale</span>
                    </span>
                    <span x-show="currentSlide === 3" x-cloak x-transition:enter="transition-all duration-1000 delay-300" x-transition:enter-start="opacity-0 translate-y-8" x-transition:enter-end="opacity-100 translate-y-0">
                        Warehousing<br><span class="text-primary-400">That Protects Inventory</span>
                    </span>
                </h1>
                
                <p class="text-lg md:text-xl mb-8 text-gray-200 max-w-2xl mx-auto lg:mx-0 leading-relaxed">
                    <span x-show="currentSlide === 0" x-cloak>End-to-end freight and courier coverage with dependable delivery windows and real-time visibility.</span>
                    <span x-show="currentSlide === 1" x-cloak>Priority courier services with proactive tracking, secure handling, and responsive support.</span>
                    <span x-show="currentSlide === 2" x-cloak>Scalable freight programs tailored to complex routes, compliance, and growing demand.</span>
                    <span x-show="currentSlide === 3" x-cloak>Secure, monitored warehousing that keeps inventory visible, protected, and ready to move.</span>
                </p>
                
                <div class="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start items-center">
                    <a href="about" class="bg-primary-600 text-white px-8 py-4 rounded-lg hover:bg-primary-700 transition-all duration-300 font-semibold text-lg shadow-lg hover:shadow-xl transform hover:-translate-y-1">
                        Learn More
                    </a>
                    <a href="contact" class="bg-transparent border-2 border-white text-white px-8 py-4 rounded-lg hover:bg-white hover:text-gray-900 transition-all duration-300 font-semibold text-lg">
                        Contact Us <i class="fas fa-arrow-right ml-2"></i>
                    </a>
                </div>

                <div class="mt-10 grid grid-cols-2 sm:grid-cols-3 gap-4">
                    <div class="rounded-lg border border-white/20 bg-white/10 px-4 py-3 text-center">
                        <div class="text-xl font-bold text-white">160+</div>
                        <div class="text-xs uppercase tracking-wide text-gray-200">Countries</div>
                    </div>
                    <div class="rounded-lg border border-white/20 bg-white/10 px-4 py-3 text-center">
                        <div class="text-xl font-bold text-white">99.8%</div>
                        <div class="text-xs uppercase tracking-wide text-gray-200">On-Time</div>
                    </div>
                    <div class="rounded-lg border border-white/20 bg-white/10 px-4 py-3 text-center">
                        <div class="text-xl font-bold text-white">24/7</div>
                        <div class="text-xs uppercase tracking-wide text-gray-200">Support</div>
                    </div>
                </div>
            </div>

            <div class="lg:col-span-5">
                <div class="rounded-2xl border border-white/20 bg-white/10 backdrop-blur-sm p-6 lg:p-8 text-white shadow-2xl">
                    <h3 class="text-xl font-semibold mb-4">Built for mission-critical shipments</h3>
                    <p class="text-gray-200 mb-6">Confidence at every checkpoint, powered by secure handling and visibility across the route.</p>
                    <ul class="space-y-4">
                        <li class="flex items-start gap-3">
                            <span class="w-10 h-10 bg-primary-600 rounded-full flex items-center justify-center flex-shrink-0">
                                <i class="fas fa-search-location text-white"></i>
                            </span>
                            <div>
                                <div class="font-semibold">Real-time tracking</div>
                                <div class="text-sm text-gray-200">Live status updates and route visibility.</div>
                            </div>
                        </li>
                        <li class="flex items-start gap-3">
                            <span class="w-10 h-10 bg-primary-600 rounded-full flex items-center justify-center flex-shrink-0">
                                <i class="fas fa-shield-alt text-white"></i>
                            </span>
                            <div>
                                <div class="font-semibold">Secure handling</div>
                                <div class="text-sm text-gray-200">Certified processes and protected custody.</div>
                            </div>
                        </li>
                        <li class="flex items-start gap-3">
                            <span class="w-10 h-10 bg-primary-600 rounded-full flex items-center justify-center flex-shrink-0">
                                <i class="fas fa-headset text-white"></i>
                            </span>
                            <div>
                                <div class="font-semibold">Dedicated support</div>
                                <div class="text-sm text-gray-200">Expert guidance 24/7 from our team.</div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Slide Indicators -->
    <div class="absolute bottom-8 left-1/2 transform -translate-x-1/2 flex space-x-2 z-20">
        <template x-for="i in slides" :key="i">
            <button @click="currentSlide = i - 1" :class="currentSlide === (i - 1) ? 'bg-primary-500' : 'bg-white bg-opacity-50'" class="w-3 h-3 rounded-full transition-all duration-300"></button>
        </template>
    </div>

    <!-- Scroll Down Indicator -->
    <div class="absolute bottom-8 left-8 text-white animate-bounce hidden md:flex">
        <div class="flex flex-col items-center">
            <span class="text-sm mb-2">Scroll Down</span>
            <i class="fas fa-chevron-down"></i>
        </div>
    </div>
</section>

<!-- Track & Trace Section -->
<section class="relative -mt-20 lg:-mt-24 z-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-white rounded-2xl shadow-2xl p-8 md:p-12">
            @if (Session::has('error'))
            <div class="mb-6 bg-red-50 border-l-4 border-red-400 p-4 rounded-lg">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-triangle text-red-400"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-red-700">
                            <strong>Error!</strong> You have entered an incorrect tracking number.
                        </p>
                    </div>
                </div>
            </div>
            @endif

            <div class="grid lg:grid-cols-12 gap-8 items-center">
                <div class="lg:col-span-5 text-center lg:text-left">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Track your shipment in seconds</h2>
                    <p class="text-gray-600 text-lg">Enter your tracking number to view the latest location, status, and estimated delivery.</p>
                    <div class="mt-6 space-y-4">
                        <div class="flex items-start gap-3">
                            <span class="w-10 h-10 bg-primary-50 rounded-full flex items-center justify-center flex-shrink-0">
                                <i class="fas fa-search-location text-primary-600"></i>
                            </span>
                            <div>
                                <div class="font-semibold text-gray-900">Live updates</div>
                                <div class="text-sm text-gray-600">Status checkpoints and route progress in real time.</div>
                            </div>
                        </div>
                        <div class="flex items-start gap-3">
                            <span class="w-10 h-10 bg-primary-50 rounded-full flex items-center justify-center flex-shrink-0">
                                <i class="fas fa-shipping-fast text-primary-600"></i>
                            </span>
                            <div>
                                <div class="font-semibold text-gray-900">Delivery confidence</div>
                                <div class="text-sm text-gray-600">Clear milestones so you always know what happens next.</div>
                            </div>
                        </div>
                    </div>
                </div>

                <form method="POST" action="{{ route('trackingresult') }}" class="lg:col-span-7">
                    @csrf
                    <div class="flex flex-col sm:flex-row gap-4">
                        <div class="flex-1">
                            <label for="trackingnumber" class="sr-only">Tracking Number</label>
                            <input type="text"
                                   id="trackingnumber"
                                   name="trackingnumber"
                                   placeholder="Enter your tracking number..."
                                   class="w-full px-6 py-4 text-lg border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                                   required>
                            <p class="mt-2 text-sm text-gray-500">Tracking numbers are available in your shipment confirmation email.</p>
                        </div>
                        <button type="submit"
                                class="bg-primary-600 text-white px-8 py-4 rounded-lg hover:bg-primary-700 transition-all duration-300 font-semibold text-lg shadow-lg hover:shadow-xl whitespace-nowrap">
                            <i class="fas fa-search mr-2"></i>Track Shipment
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<!-- Trusted Partners Section -->
<section class="py-12 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-12 gap-8 items-center">
            <div class="lg:col-span-4 text-center lg:text-left">
                <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-3">Trusted by global partners</h2>
                <p class="text-gray-600">Working with industry leaders to deliver secure, compliant, and reliable logistics worldwide.</p>
            </div>
            <div class="lg:col-span-8 grid grid-cols-2 md:grid-cols-5 gap-8 items-center opacity-70 hover:opacity-100 transition-opacity duration-300">
                <div class="flex justify-center">
                    <img src="temp/custom/images/content/partner-01.png" alt="Partner Logo" class="h-12 object-contain filter grayscale hover:grayscale-0 transition-all duration-300">
                </div>
                <div class="flex justify-center">
                    <img src="temp/custom/images/content/partner-02.png" alt="Partner Logo" class="h-12 object-contain filter grayscale hover:grayscale-0 transition-all duration-300">
                </div>
                <div class="flex justify-center">
                    <img src="temp/custom/images/content/partner-03.png" alt="Partner Logo" class="h-12 object-contain filter grayscale hover:grayscale-0 transition-all duration-300">
                </div>
                <div class="flex justify-center">
                    <img src="temp/custom/images/content/partner-04.png" alt="Partner Logo" class="h-12 object-contain filter grayscale hover:grayscale-0 transition-all duration-300">
                </div>
                <div class="flex justify-center">
                    <img src="temp/custom/images/content/partner-05.png" alt="Partner Logo" class="h-12 object-contain filter grayscale hover:grayscale-0 transition-all duration-300">
                </div>
            </div>
        </div>
    </div>
</section>

<!-- How It Works Section -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">How it works</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">A clear, secure process from pickup to delivery, with visibility at every step.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="bg-gray-50 rounded-xl p-8 border border-gray-100 text-center">
                <div class="w-14 h-14 bg-primary-600 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-box text-white text-xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-3">Schedule your shipment</h3>
                <p class="text-gray-600">Share your shipment details and we design the optimal route and service level.</p>
            </div>
            <div class="bg-gray-50 rounded-xl p-8 border border-gray-100 text-center">
                <div class="w-14 h-14 bg-primary-600 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-shipping-fast text-white text-xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-3">We move it securely</h3>
                <p class="text-gray-600">Trusted carriers and secure handling keep your cargo protected and on schedule.</p>
            </div>
            <div class="bg-gray-50 rounded-xl p-8 border border-gray-100 text-center">
                <div class="w-14 h-14 bg-primary-600 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-search-location text-white text-xl"></i>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-3">Track in real time</h3>
                <p class="text-gray-600">Monitor every checkpoint and delivery milestone with transparent updates.</p>
            </div>
        </div>
    </div>
</section>

<!-- Services Section -->
<section class="py-20 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Logistics services built around you</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Flexible, end-to-end solutions that keep your supply chain resilient and your customers confident.
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Air Freight -->
            <div class="group bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2">
                <div class="relative h-64 bg-cover bg-center" style="background-image: url('temp/custom/images/services/service1.jpg');">
                    <div class="absolute inset-0 bg-gradient-to-t from-black to-transparent opacity-60"></div>
                    <div class="absolute top-4 left-4">
                        <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center">
                            <i class="fas fa-plane text-white text-xl"></i>
                        </div>
                    </div>
                </div>
                <div class="p-6">
                    <h3 class="text-xl font-semibold text-gray-900 mb-3">Air Freight</h3>
                    <p class="text-gray-600 mb-4">
                        {{$settings->site_name}} delivers time-sensitive air freight with reliable schedules and secure handling.
                    </p>
                    <a href="services" class="text-primary-600 hover:text-primary-700 font-medium inline-flex items-center">
                        Learn More <i class="fas fa-arrow-right ml-2 text-sm"></i>
                    </a>
                </div>
            </div>

            <!-- Sea/Ocean Freight -->
            <div class="group bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2">
                <div class="relative h-64 bg-cover bg-center" style="background-image: url('temp/custom/images/services/service2.jpg');">
                    <div class="absolute inset-0 bg-gradient-to-t from-black to-transparent opacity-60"></div>
                    <div class="absolute top-4 left-4">
                        <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center">
                            <i class="fas fa-ship text-white text-xl"></i>
                        </div>
                    </div>
                </div>
                <div class="p-6">
                    <h3 class="text-xl font-semibold text-gray-900 mb-3">Sea/Ocean Freight</h3>
                    <p class="text-gray-600 mb-4">
                        Flexible FCL and LCL options with end-to-end visibility across global ports and lanes.
                    </p>
                    <a href="services" class="text-primary-600 hover:text-primary-700 font-medium inline-flex items-center">
                        Learn More <i class="fas fa-arrow-right ml-2 text-sm"></i>
                    </a>
                </div>
            </div>

            <!-- Road Transportation -->
            <div class="group bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2">
                <div class="relative h-64 bg-cover bg-center" style="background-image: url('temp/custom/images/services/service3.jpg');">
                    <div class="absolute inset-0 bg-gradient-to-t from-black to-transparent opacity-60"></div>
                    <div class="absolute top-4 left-4">
                        <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center">
                            <i class="fas fa-truck text-white text-xl"></i>
                        </div>
                    </div>
                </div>
                <div class="p-6">
                    <h3 class="text-xl font-semibold text-gray-900 mb-3">Road Transportation</h3>
                    <p class="text-gray-600 mb-4">
                        Dependable domestic trucking with optimized routing and scheduled pickups.
                    </p>
                    <a href="services" class="text-primary-600 hover:text-primary-700 font-medium inline-flex items-center">
                        Learn More <i class="fas fa-arrow-right ml-2 text-sm"></i>
                    </a>
                </div>
            </div>

            <!-- Diplomatic Services -->
            <div class="group bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2">
                <div class="relative h-64 bg-cover bg-center" style="background-image: url('temp/custom/images/services/service4.jpg');">
                    <div class="absolute inset-0 bg-gradient-to-t from-black to-transparent opacity-60"></div>
                    <div class="absolute top-4 left-4">
                        <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center">
                            <i class="fas fa-shield-alt text-white text-xl"></i>
                        </div>
                    </div>
                </div>
                <div class="p-6">
                    <h3 class="text-xl font-semibold text-gray-900 mb-3">Diplomatic Bag & Secure Logistics</h3>
                    <p class="text-gray-600 mb-4">
                        Secure courier service for sensitive materials with verified chain of custody.
                    </p>
                    <a href="diplomatic" class="text-primary-600 hover:text-primary-700 font-medium inline-flex items-center">
                        Learn More <i class="fas fa-arrow-right ml-2 text-sm"></i>
                    </a>
                </div>
            </div>

            <!-- Warehousing -->
            <div class="group bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2">
                <div class="relative h-64 bg-cover bg-center" style="background-image: url('temp/custom/images/services/service5.jpg');">
                    <div class="absolute inset-0 bg-gradient-to-t from-black to-transparent opacity-60"></div>
                    <div class="absolute top-4 left-4">
                        <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center">
                            <i class="fas fa-warehouse text-white text-xl"></i>
                        </div>
                    </div>
                </div>
                <div class="p-6">
                    <h3 class="text-xl font-semibold text-gray-900 mb-3">Warehousing</h3>
                    <p class="text-gray-600 mb-4">
                        Secure storage with inventory control, staging, and distribution support.
                    </p>
                    <a href="services" class="text-primary-600 hover:text-primary-700 font-medium inline-flex items-center">
                        Learn More <i class="fas fa-arrow-right ml-2 text-sm"></i>
                    </a>
                </div>
            </div>

            <!-- Packaging & Storage -->
            <div class="group bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2">
                <div class="relative h-64 bg-cover bg-center" style="background-image: url('temp/custom/images/services/service6.jpg');">
                    <div class="absolute inset-0 bg-gradient-to-t from-black to-transparent opacity-60"></div>
                    <div class="absolute top-4 left-4">
                        <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center">
                            <i class="fas fa-box text-white text-xl"></i>
                        </div>
                    </div>
                </div>
                <div class="p-6">
                    <h3 class="text-xl font-semibold text-gray-900 mb-3">Packaging & Storage</h3>
                    <p class="text-gray-600 mb-4">
                        Professional packaging and insured storage for fragile, regulated, or high-value goods.
                    </p>
                    <a href="services" class="text-primary-600 hover:text-primary-700 font-medium inline-flex items-center">
                        Learn More <i class="fas fa-arrow-right ml-2 text-sm"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Why Choose Us Section -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-12 gap-12 items-start">
            <div class="lg:col-span-4 text-center lg:text-left">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Why businesses choose us</h2>
                <p class="text-lg text-gray-600 mb-6">
                    A modern logistics partner built for reliability, transparency, and global reach.
                </p>
                <a href="about" class="inline-flex items-center text-primary-600 hover:text-primary-700 font-semibold">
                    Learn about {{$settings->site_name}} <i class="fas fa-arrow-right ml-2 text-sm"></i>
                </a>
            </div>

            <div class="lg:col-span-8 grid grid-cols-1 sm:grid-cols-2 gap-6">
                <div class="bg-gray-50 rounded-xl p-6 border border-gray-100">
                    <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center mb-4">
                        <i class="fas fa-search-location text-white text-xl"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Track & Trace</h3>
                    <p class="text-gray-600">Real-time shipment visibility with proactive status updates.</p>
                </div>

                <div class="bg-gray-50 rounded-xl p-6 border border-gray-100">
                    <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center mb-4">
                        <i class="fas fa-shield-alt text-white text-xl"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Secure Warehousing</h3>
                    <p class="text-gray-600">Controlled facilities with advanced monitoring and compliance.</p>
                </div>

                <div class="bg-gray-50 rounded-xl p-6 border border-gray-100">
                    <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center mb-4">
                        <i class="fas fa-shipping-fast text-white text-xl"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Express Delivery</h3>
                    <p class="text-gray-600">Reliable transit times backed by diversified carrier networks.</p>
                </div>

                <div class="bg-gray-50 rounded-xl p-6 border border-gray-100">
                    <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center mb-4">
                        <i class="fas fa-truck text-white text-xl"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Domestic Coverage</h3>
                    <p class="text-gray-600">Next-business-day options for time-sensitive parcels.</p>
                </div>

                <div class="bg-gray-50 rounded-xl p-6 border border-gray-100">
                    <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center mb-4">
                        <i class="fas fa-globe text-white text-xl"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Global Reach</h3>
                    <p class="text-gray-600">Worldwide coverage by air, sea, and ground with seamless coordination.</p>
                </div>

                <div class="bg-gray-50 rounded-xl p-6 border border-gray-100">
                    <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center mb-4">
                        <i class="fas fa-headset text-white text-xl"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">24/7 Support</h3>
                    <p class="text-gray-600">Dedicated specialists ready to assist at every milestone.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Stats & Achievements Section -->
<section class="py-20 bg-gradient-to-br from-primary-600 to-primary-800 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-10">
            <h2 class="text-3xl md:text-4xl font-bold mb-4">Operational scale you can trust</h2>
            <p class="text-xl text-primary-200 max-w-2xl mx-auto">Delivering excellence across the globe with industry-leading standards</p>
        </div>

        <!-- Main Stats -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-8 mb-12">
            <!-- Delivered Packages -->
            <div class="text-center p-4 bg-white/10 backdrop-blur-sm rounded-xl hover:bg-white/15 transition-all duration-300">
                <div class="w-12 h-12 bg-white/20 rounded-full flex items-center justify-center mx-auto mb-3">
                    <i class="fas fa-box text-white text-xl"></i>
                </div>
                <div class="stat-number text-3xl md:text-4xl font-bold mb-2 transform translate-y-4 opacity-0 transition-all duration-700"
                     style="transition-delay: 200ms;">
                    101,273+
                </div>
                <div class="text-primary-200 text-sm md:text-base font-medium">
                    Delivered Packages
                </div>
            </div>

            <!-- KM Per Year -->
            <div class="text-center p-4 bg-white/10 backdrop-blur-sm rounded-xl hover:bg-white/15 transition-all duration-300">
                <div class="w-12 h-12 bg-white/20 rounded-full flex items-center justify-center mx-auto mb-3">
                    <i class="fas fa-route text-white text-xl"></i>
                </div>
                <div class="stat-number text-3xl md:text-4xl font-bold mb-2 transform translate-y-4 opacity-0 transition-all duration-700"
                     style="transition-delay: 400ms;">
                    673,754+
                </div>
                <div class="text-primary-200 text-sm md:text-base font-medium">
                    KM Per Year
                </div>
            </div>

            <!-- Happy Clients -->
            <div class="text-center p-4 bg-white/10 backdrop-blur-sm rounded-xl hover:bg-white/15 transition-all duration-300">
                <div class="w-12 h-12 bg-white/20 rounded-full flex items-center justify-center mx-auto mb-3">
                    <i class="fas fa-smile text-white text-xl"></i>
                </div>
                <div class="stat-number text-3xl md:text-4xl font-bold mb-2 transform translate-y-4 opacity-0 transition-all duration-700"
                     style="transition-delay: 600ms;">
                    16,714+
                </div>
                <div class="text-primary-200 text-sm md:text-base font-medium">
                    Happy Clients
                </div>
            </div>

            <!-- Countries Served -->
            <div class="text-center p-4 bg-white/10 backdrop-blur-sm rounded-xl hover:bg-white/15 transition-all duration-300">
                <div class="w-12 h-12 bg-white/20 rounded-full flex items-center justify-center mx-auto mb-3">
                    <i class="fas fa-globe text-white text-xl"></i>
                </div>
                <div class="stat-number text-3xl md:text-4xl font-bold mb-2 transform translate-y-4 opacity-0 transition-all duration-700"
                     style="transition-delay: 800ms;">
                    160+
                </div>
                <div class="text-primary-200 text-sm md:text-base font-medium">
                    Countries Served
                </div>
            </div>
        </div>

        <!-- Additional Professional Metrics -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-10">
            <!-- Delivery Performance -->
            <div class="bg-white/10 backdrop-blur-sm rounded-xl p-6 hover:bg-white/15 transition-all duration-300">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center mr-4">
                        <i class="fas fa-shipping-fast text-white"></i>
                    </div>
                    <h3 class="text-xl font-semibold">Delivery Performance</h3>
                </div>
                <div class="flex items-center mb-2">
                    <div class="text-3xl font-bold mr-2">99.8%</div>
                    <div class="text-primary-200">On-Time Delivery</div>
                </div>
                <p class="text-sm text-primary-200">Industry-leading on-time delivery performance across all shipping methods</p>
            </div>

            <!-- Tracking Precision -->
            <div class="bg-white/10 backdrop-blur-sm rounded-xl p-6 hover:bg-white/15 transition-all duration-300">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center mr-4">
                        <i class="fas fa-search-location text-white"></i>
                    </div>
                    <h3 class="text-xl font-semibold">Tracking Precision</h3>
                </div>
                <div class="flex items-center mb-2">
                    <div class="text-3xl font-bold mr-2">Real-time</div>
                    <div class="text-primary-200">GPS Accuracy</div>
                </div>
                <p class="text-sm text-primary-200">Advanced tracking with minute-by-minute updates and GPS precision</p>
            </div>

            <!-- Customer Satisfaction -->
            <div class="bg-white/10 backdrop-blur-sm rounded-xl p-6 hover:bg-white/15 transition-all duration-300">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center mr-4">
                        <i class="fas fa-star text-white"></i>
                    </div>
                    <h3 class="text-xl font-semibold">Client Satisfaction</h3>
                </div>
                <div class="flex items-center mb-2">
                    <div class="text-3xl font-bold mr-2">4.9/5</div>
                    <div class="text-primary-200">Average Rating</div>
                </div>
                <p class="text-sm text-primary-200">Outstanding client satisfaction across all logistics services</p>
            </div>
        </div>

        <!-- Industry Recognition Row -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Experience -->
            <div class="flex items-center bg-white/10 backdrop-blur-sm rounded-xl p-4 hover:bg-white/15 transition-all duration-300">
                <div class="w-14 h-14 bg-white/20 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                    <i class="fas fa-calendar-check text-white text-xl"></i>
                </div>
                <div>
                    <div class="stat-number text-2xl font-bold transform translate-y-4 opacity-0 transition-all duration-700" style="transition-delay: 1000ms;">
                        11+ Years
                    </div>
                    <div class="text-primary-200 text-sm">Industry Experience</div>
                </div>
            </div>

            <!-- Security Rating -->
            <div class="flex items-center bg-white/10 backdrop-blur-sm rounded-xl p-4 hover:bg-white/15 transition-all duration-300">
                <div class="w-14 h-14 bg-white/20 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                    <i class="fas fa-shield-alt text-white text-xl"></i>
                </div>
                <div>
                    <div class="stat-number text-2xl font-bold transform translate-y-4 opacity-0 transition-all duration-700" style="transition-delay: 1200ms;">
                        ISO 27001
                    </div>
                    <div class="text-primary-200 text-sm">Security Certification</div>
                </div>
            </div>

            <!-- Awards -->
            <div class="flex items-center bg-white/10 backdrop-blur-sm rounded-xl p-4 hover:bg-white/15 transition-all duration-300">
                <div class="w-14 h-14 bg-white/20 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                    <i class="fas fa-trophy text-white text-xl"></i>
                </div>
                <div>
                    <div class="stat-number text-2xl font-bold transform translate-y-4 opacity-0 transition-all duration-700" style="transition-delay: 1400ms;">
                        8+ Awards
                    </div>
                    <div class="text-primary-200 text-sm">Industry Recognition</div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Pure JavaScript Intersection Observer for stats animation
        document.addEventListener('DOMContentLoaded', function() {
            const statNumbers = document.querySelectorAll('.stat-number');
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.remove('translate-y-4', 'opacity-0');
                        entry.target.classList.add('translate-y-0', 'opacity-100');
                    }
                });
            }, {
                threshold: 0.5,
                rootMargin: '0px 0px -50px 0px'
            });

            statNumbers.forEach(stat => {
                observer.observe(stat);
            });
        });
    </script>
</section>

<!-- Testimonials Section -->
<section class="py-20 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-12 gap-12 items-start">
            <div class="lg:col-span-4 text-center lg:text-left">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">What our clients say</h2>
                <p class="text-lg text-gray-600">
                    Decision makers rely on {{$settings->site_name}} for consistent delivery, clear updates, and accountable service.
                </p>
                <div class="mt-6 inline-flex items-center gap-3 rounded-full border border-gray-200 bg-white px-4 py-2">
                    <div class="flex text-yellow-400">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <span class="text-sm text-gray-500">Consistent 5-star feedback</span>
                </div>
                <p class="mt-4 text-sm text-gray-500">
                    Every shipment is supported by proactive communication and dedicated specialists.
                </p>
            </div>

            <div class="lg:col-span-8 grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Testimonial 1 -->
                <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-8 transition-all duration-300 hover:shadow-xl">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex text-yellow-400">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                        <span class="text-xs text-gray-400 uppercase tracking-wide">Verified client</span>
                    </div>
                    <blockquote class="text-gray-600 mb-6 leading-relaxed">
                        "{{$settings->site_name}} delivers reliable time windows and consistent communication that keeps our logistics team confident."
                    </blockquote>
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center text-white font-semibold mr-4">
                            MP
                        </div>
                        <div>
                            <div class="font-semibold text-gray-900">Monique Pete</div>
                            <div class="text-sm text-gray-500">Logistics Manager, Martrax Inc.</div>
                        </div>
                    </div>
                </div>

                <!-- Testimonial 2 -->
                <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-8 transition-all duration-300 hover:shadow-xl">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex text-yellow-400">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                        <span class="text-xs text-gray-400 uppercase tracking-wide">Verified client</span>
                    </div>
                    <blockquote class="text-gray-600 mb-6 leading-relaxed">
                        "When timelines are tight, {{$settings->site_name}} responds quickly and delivers without surprises."
                    </blockquote>
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center text-white font-semibold mr-4">
                            SA
                        </div>
                        <div>
                            <div class="font-semibold text-gray-900">Steve Anderson</div>
                            <div class="text-sm text-gray-500">President/Owner, Duplication Factory</div>
                        </div>
                    </div>
                </div>

                <!-- Testimonial 3 -->
                <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-8 transition-all duration-300 hover:shadow-xl md:col-span-2">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex text-yellow-400">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                        <span class="text-xs text-gray-400 uppercase tracking-wide">Verified client</span>
                    </div>
                    <blockquote class="text-gray-600 mb-6 leading-relaxed">
                        "Clear updates and dependable carriers make {{$settings->site_name}} our trusted partner for critical shipments."
                    </blockquote>
                    <div class="flex items-center">
                        <div class="w-12 h-12 bg-primary-600 rounded-full flex items-center justify-center text-white font-semibold mr-4">
                            CB
                        </div>
                        <div>
                            <div class="font-semibold text-gray-900">Cathy Beckman</div>
                            <div class="text-sm text-gray-500">Logistics Team, Oxea Chemicals</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-12 gap-12 items-start">
            <div class="lg:col-span-4 text-center lg:text-left">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Frequently asked questions</h2>
                <p class="text-lg text-gray-600 mb-6">Quick answers to common shipping and tracking questions.</p>
                <a href="faq" class="inline-flex items-center text-primary-600 hover:text-primary-700 font-semibold">
                    Visit the FAQ page <i class="fas fa-arrow-right ml-2 text-sm"></i>
                </a>
            </div>

            <div class="lg:col-span-8 space-y-4">
                <div class="bg-gray-50 border border-gray-100 rounded-xl p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">How do I track my shipment?</h3>
                    <p class="text-gray-600">Use the tracking number from your confirmation email to view the latest status and location.</p>
                </div>
                <div class="bg-gray-50 border border-gray-100 rounded-xl p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">When will tracking updates appear?</h3>
                    <p class="text-gray-600">Updates usually appear shortly after pickup. If your shipment is new, allow up to 24 hours.</p>
                </div>
                <div class="bg-gray-50 border border-gray-100 rounded-xl p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Can you handle urgent or high-value cargo?</h3>
                    <p class="text-gray-600">Yes. We offer priority handling and secure chain-of-custody options for sensitive shipments.</p>
                </div>
                <div class="bg-gray-50 border border-gray-100 rounded-xl p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">How do I request a quote?</h3>
                    <p class="text-gray-600">Reach out through our contact page and we will tailor a quote to your requirements.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action Section -->
<section class="py-20 bg-gradient-to-r from-primary-600 to-primary-800">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <div class="max-w-3xl mx-auto">
            <h2 class="text-3xl md:text-4xl font-bold text-white mb-6">
                Ready to ship with confidence?
            </h2>
            <p class="text-xl text-primary-100 mb-8 leading-relaxed">
                Get started with our professional logistics services today. Contact us for a tailored quote and experience the difference.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="contact" class="bg-white text-primary-600 px-8 py-4 rounded-lg hover:bg-gray-100 transition-all duration-300 font-semibold text-lg shadow-lg">
                    Get Free Quote
                </a>
                <a href="order" class="bg-transparent border-2 border-white text-white px-8 py-4 rounded-lg hover:bg-white hover:text-primary-600 transition-all duration-300 font-semibold text-lg">
                    Track Shipment
                </a>
            </div>
        </div>
    </div>
</section>

@endsection
