﻿<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Deposit Confirmation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #111827;
            background-color: #f3f4f6;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 640px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 12px;
            border: 1px solid #e5e7eb;
            box-shadow: 0 12px 30px rgba(15, 23, 42, 0.08);
            overflow: hidden;
        }
        .header {
            background-color: #38c172;
            color: #ffffff;
            padding: 24px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 22px;
            font-weight: 700;
        }
        .header p {
            margin: 6px 0 0;
            font-size: 13px;
            opacity: 0.9;
        }
        .content {
            padding: 24px;
        }
        .section-title {
            font-size: 16px;
            font-weight: 600;
            margin: 0 0 12px;
            color: #111827;
        }
        .detail-table {
            width: 100%;
            border-collapse: collapse;
            margin: 0 0 16px;
        }
        .detail-table td {
            padding: 8px 0;
            border-bottom: 1px solid #e5e7eb;
            font-size: 14px;
        }
        .detail-table td.label {
            color: #6b7280;
            width: 40%;
        }
        .amount {
            font-size: 22px;
            font-weight: 700;
            color: #38c172;
        }
        .steps {
            margin: 0;
            padding-left: 18px;
            color: #4b5563;
        }
        .steps li {
            margin-bottom: 8px;
        }
        .note {
            background-color: #fef9c3;
            border: 1px solid #facc15;
            color: #854d0e;
            padding: 14px;
            border-radius: 8px;
            margin: 16px 0;
            font-size: 14px;
        }
        .footer {
            text-align: center;
            padding: 20px;
            background-color: #f9fafb;
            color: #6b7280;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Deposit Confirmation</h1>
            <p>{{ config('app.name') }}</p>
        </div>
        <div class="content">
            <p>Hello {{ $user->name }},</p>
            <p>Thank you for your deposit. We have received your request and it is now pending verification.</p>

            <h2 class="section-title">Deposit Summary</h2>
            <table class="detail-table" role="presentation">
                <tr>
                    <td class="label">Amount</td>
                    <td><span class="amount">{{ $user->currency }}{{ number_format($deposit->amount, 2) }}</span></td>
                </tr>
                <tr>
                    <td class="label">Payment Method</td>
                    <td>{{ $deposit->payment_mode }}</td>
                </tr>
                <tr>
                    <td class="label">Date</td>
                    <td>{{ $deposit->created_at->format('M d, Y H:i') }}</td>
                </tr>
                <tr>
                    <td class="label">Status</td>
                    <td>Pending</td>
                </tr>
            </table>

            <h2 class="section-title">What happens next</h2>
            <ul class="steps">
                <li>Your payment proof has been received</li>
                <li>Our team will verify your payment</li>
                <li>Your account will be credited once confirmed</li>
                <li>You will receive a confirmation email when complete</li>
            </ul>

            <div class="note">
                Verification typically takes 1 to 24 hours. Thank you for your patience.
            </div>

            <p>If you have any questions, please contact our support team.</p>
        </div>
        <div class="footer">
            &copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
        </div>
    </div>
</body>
</html>
