﻿<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config('app.name') }} - Notification</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
            line-height: 1.6;
            color: #111827;
            margin: 0;
            padding: 0;
            background-color: #f3f4f6;
        }
        .email-container {
            max-width: 640px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 12px;
            overflow: hidden;
            border: 1px solid #e5e7eb;
            box-shadow: 0 12px 30px rgba(15, 23, 42, 0.08);
        }
        .email-header {
            background-color: #0369a1;
            color: #ffffff;
            padding: 24px;
            text-align: center;
        }
        .email-header h1 {
            margin: 0;
            font-size: 22px;
            font-weight: 700;
        }
        .email-header p {
            margin: 6px 0 0;
            font-size: 13px;
            opacity: 0.9;
        }
        .email-body {
            padding: 28px;
        }
        .greeting {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 16px;
            color: #111827;
        }
        .content {
            margin-bottom: 24px;
            color: #4b5563;
        }
        .attachment-image {
            text-align: center;
            margin: 20px 0;
        }
        .attachment-image img {
            max-width: 100%;
            height: auto;
            border-radius: 10px;
            border: 1px solid #e5e7eb;
        }
        .email-footer {
            background-color: #f9fafb;
            padding: 20px;
            text-align: center;
            border-top: 1px solid #e5e7eb;
        }
        .footer-text {
            margin: 0;
            color: #6b7280;
            font-size: 12px;
        }
        .company-name {
            font-weight: 600;
            color: #0369a1;
        }
        a {
            color: #0369a1;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="email-header">
            <h1>{{ config('app.name') }}</h1>
            <p>Notification</p>
        </div>

        <div class="email-body">
            <div class="greeting">
                {{ $salutaion ? $salutaion : "Hello" }} {{ $recipient }},
            </div>

            @if ($attachment != null)
                <div class="attachment-image">
                    <img src="{{ $message->embed(asset('storage/'. $attachment)) }}" alt="Attachment">
                </div>
            @endif

            <div class="content">
                {!! $body !!}
            </div>
        </div>

        <div class="email-footer">
            <p class="footer-text">
                Thanks,<br>
                <span class="company-name">{{ config('app.name') }}</span>
            </p>
        </div>
    </div>
</body>
</html>
